import { toast } from '@/components/custom-toast';
import { router } from '@inertiajs/react';

// Function to display flash messages as toasts
export function setupFlashMessages() {
  // Display initial flash messages
  const page = (window as any).page;
  if (page?.props?.flash) {
    if (page.props.flash.success) {
      toast.success(page.props.flash.success);
    }
    if (page.props.flash.error) {
      toast.error(page.props.flash.error);
    }
  }

  // Listen for navigation events to display new flash messages
  router.on('success', (event) => {
    const flash = event.detail.page.props.flash;
    if (flash?.success) {
      toast.success(flash.success);
    }
    if (flash?.error) {
      toast.error(flash.error);
    }
  });
}